﻿using Percent___Qualification_work.Classes;
using System;
using System.IO;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Security.Cryptography;
using System.Drawing;
using System.Threading;

namespace Percent___Qualification_work.userControls
{
    public partial class Profile : UserControl
    {
        string[] checkSymbols = { "!", "@", "#", "$", "%", "^", "&", "*", "(", ")" };
        string oldPassword;
        string newPassword;
        byte[] imageBlob;
        public Profile()
        {
            InitializeComponent();
            
        }

        private void Profile_Load(object sender, EventArgs e)
        {
            username.Text = "Username: "+Authentication.ActiveUser;
            if(DatabaseConnection.Instance.GetProfilePicture(Authentication.ActiveUserID) != null)
            {
                pictureBox1.Image = ConvertBytesToImage(DatabaseConnection.Instance.GetProfilePicture(Authentication.ActiveUserID));
            }
            
        }

        private void changepassword_Click(object sender, EventArgs e)
        {
                changePswrdPanel.Visible = true;
                changepassword.Visible = false;    
        }

        private void confirmChange_Click(object sender, EventArgs e)
        {
            oldPassword = HashPassword(oldPasswordInput.Text);
            newPassword = HashPassword(newPasswordInput.Text);
            if (oldPassword != "" && newPassword != "")
            {
                if (oldPassword == DatabaseConnection.Instance.GetUserPassword(Authentication.ActiveUserID))
                {
                    bool isValidPassword = newPassword.Length >= 8 &&
                                       checkSymbols.Any(symbol => newPassword.Contains(symbol)) &&
                                       newPassword.Any(char.IsDigit) &&
                                       newPassword.Any(char.IsUpper);
                    if (isValidPassword)
                    {
                        DatabaseConnection.Instance.ChangePassword(Authentication.ActiveUserID, newPassword);
                        MessageBox.Show("Password Successfully changed!");
                        changePswrdPanel.Visible = false;
                        changepassword.Visible = true;
                    }
                    else
                    {
                        MessageBox.Show("Password must: \n" +
                        "Be atleast 8 symbols long\n" +
                        "Contain atleast 1 number\n" +
                        "Contain atleast 1 uppercase letter\n" +
                        "Contain atleast 1 special symbol(!,@,#,$,%,^,&,*,(,))");
                    }
                }
                else
                {
                    MessageBox.Show("Old password is not correct!");
                }
            }
            else
            {
                MessageBox.Show("Please fill in both the fields!");
            }
                     
        }

        private void cancelChange_Click(object sender, EventArgs e)
        {
            changePswrdPanel.Visible = false;
            changepassword.Visible = true;
            oldPassword = "";
            oldPasswordInput.Text = "";
            newPassword = "";
            newPasswordInput.Text = "";    
        }

        private string HashPassword(string password)
        {
            using (SHA256 sha256 = SHA256.Create())
            {
                byte[] bytes = sha256.ComputeHash(Encoding.UTF8.GetBytes(password));
                StringBuilder builder = new StringBuilder();
                for (int i = 0; i < bytes.Length; i++)
                {
                    builder.Append(bytes[i].ToString("x2"));
                }
                return builder.ToString();
            }
        }

        private void pictureBox1_Click(object sender, EventArgs e)
        {
            DialogResult result = openFileDialog1.ShowDialog();
        }
        

        private void openFileDialog1_FileOk(object sender, System.ComponentModel.CancelEventArgs e)
        {
            string fileName = openFileDialog1.FileName;
            string fileExtension = Path.GetExtension(fileName).ToLower();

            // Check if the file is a PNG or JPG/JPEG
            if (fileExtension == ".png" || fileExtension == ".jpg" || fileExtension == ".jpeg")
            {
                // Convert the image file to a byte array
                imageBlob = File.ReadAllBytes(fileName);
                DatabaseConnection.Instance.ChangeProfilePicture(Authentication.ActiveUserID, imageBlob);
                pictureBox1.Image = ConvertBytesToImage(DatabaseConnection.Instance.GetProfilePicture(Authentication.ActiveUserID));
            }
            else
            {
                MessageBox.Show("Please select a valid image file (.png, .jpg, .jpeg).", "Invalid File Type", MessageBoxButtons.OK, MessageBoxIcon.Error);
                e.Cancel = true; // Cancel the file selection if the file is not valid
            }
        }

        private Image ConvertBytesToImage(byte[] imageData)
        {
            using (var ms = new System.IO.MemoryStream(imageData))
            {
                return Image.FromStream(ms);
            }
        }
    }
}
